<?php

use App\Http\Controllers\SchoolController;
use App\Http\Controllers\StudentController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

Route::get('/user', function (Request $request) {
    return $request->user();
})->middleware('auth:sanctum');

// School CRUD API routes (with 'api' name prefix to avoid conflicts with web routes)
Route::resource('schools', SchoolController::class)
    ->middleware('auth:sanctum')
    ->names('api.schools');

// Student CRUD API routes
Route::resource('students', StudentController::class)
    ->middleware('auth:sanctum')
    ->names('api.students');
