<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Student Details') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-xl sm:rounded-lg p-6 mb-6">
                <dl class="grid grid-cols-1 gap-x-4 gap-y-6 sm:grid-cols-2">
                    <div>
                        <dt class="text-sm font-medium text-gray-500">{{ __('Name') }}</dt>
                        <dd class="mt-1 text-sm text-gray-900 font-medium">{{ $student->name }}</dd>
                    </div>

                    <div>
                        <dt class="text-sm font-medium text-gray-500">{{ __('Student ID') }}</dt>
                        <dd class="mt-1 text-sm text-gray-900 font-medium">{{ $student->student_id }}</dd>
                    </div>

                    <div>
                        <dt class="text-sm font-medium text-gray-500">{{ __('Email') }}</dt>
                        <dd class="mt-1 text-sm text-gray-900">{{ $student->email ?? '-' }}</dd>
                    </div>

                    <div>
                        <dt class="text-sm font-medium text-gray-500">{{ __('School') }}</dt>
                        <dd class="mt-1 text-sm text-gray-900">
                            <a href="{{ route('schools.show', $student->school) }}"
                                class="text-blue-600 hover:text-blue-900">
                                {{ $student->school->name }}
                            </a>
                        </dd>
                    </div>

                    <div class="sm:col-span-2">
                        <dt class="text-sm font-medium text-gray-500">{{ __('Biometric Template') }}</dt>
                        <dd class="mt-1 text-sm text-gray-900 font-mono bg-gray-50 p-3 rounded break-all">
                            {{ $student->biometric_template ?? '(Not set)' }}
                        </dd>
                    </div>

                    <div>
                        <dt class="text-sm font-medium text-gray-500">{{ __('Created') }}</dt>
                        <dd class="mt-1 text-sm text-gray-900">{{ $student->created_at->format('M d, Y h:i A') }}</dd>
                    </div>

                    <div>
                        <dt class="text-sm font-medium text-gray-500">{{ __('Last Updated') }}</dt>
                        <dd class="mt-1 text-sm text-gray-900">{{ $student->updated_at->format('M d, Y h:i A') }}</dd>
                    </div>
                </dl>
            </div>

            <div class="flex gap-4">
                <a href="{{ route('students.edit', $student) }}"
                    class="inline-flex items-center px-6 py-3 bg-indigo-600 text-white font-semibold rounded-lg hover:bg-indigo-700 transition">
                    {{ __('Edit') }}
                </a>
                <a href="{{ route('students.index') }}"
                    class="inline-flex items-center px-6 py-3 bg-gray-500 text-white font-semibold rounded-lg hover:bg-gray-600 transition">
                    {{ __('Back to Students') }}
                </a>
                <form action="{{ route('students.destroy', $student) }}" method="POST" class="inline"
                    onsubmit="return confirm('Are you sure you want to delete this student?');">
                    @csrf
                    @method('DELETE')
                    <button type="submit"
                        class="inline-flex items-center px-6 py-3 bg-red-600 text-white font-semibold rounded-lg hover:bg-red-700 transition">
                        {{ __('Delete') }}
                    </button>
                </form>
            </div>
        </div>
    </div>
</x-app-layout>
