<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Edit Student') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-xl sm:rounded-lg p-6">
                <form action="{{ route('students.update', $student) }}" method="POST" class="space-y-6">
                    @csrf
                    @method('PATCH')

                    <div>
                        <label for="school_id" class="block text-sm font-medium text-gray-700">{{ __('School') }}</label>
                        <select name="school_id" id="school_id"
                            class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring-indigo-500 @error('school_id') border-red-500 @enderror"
                            required>
                            <option value="">{{ __('Select School') }}</option>
                            @foreach ($schools as $school)
                                <option value="{{ $school->id }}" @selected(old('school_id', $student->school_id) == $school->id)>
                                    {{ $school->name }}
                                </option>
                            @endforeach
                        </select>
                        @error('school_id')
                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label for="name"
                            class="block text-sm font-medium text-gray-700">{{ __('Student Name') }}</label>
                        <input type="text" name="name" id="name" value="{{ old('name', $student->name) }}"
                            class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring-indigo-500 @error('name') border-red-500 @enderror"
                            required>
                        @error('name')
                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label for="student_id"
                                class="block text-sm font-medium text-gray-700">{{ __('Student ID') }}</label>
                            <input type="text" name="student_id" id="student_id"
                                value="{{ old('student_id', $student->student_id) }}"
                                class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring-indigo-500 @error('student_id') border-red-500 @enderror"
                                required>
                            @error('student_id')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <div>
                            <label for="email"
                                class="block text-sm font-medium text-gray-700">{{ __('Email') }}</label>
                            <input type="email" name="email" id="email"
                                value="{{ old('email', $student->email) }}"
                                class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring-indigo-500 @error('email') border-red-500 @enderror">
                            @error('email')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>

                    <div>
                        <div class="flex justify-between items-center mb-2">
                            <label for="biometric_template"
                                class="block text-sm font-medium text-gray-700">{{ __('Biometric Template') }}</label>
                            <button type="button" onclick="openBiometricModal()"
                                class="text-sm px-3 py-1 bg-indigo-600 text-white rounded hover:bg-indigo-700 transition">
                                📱 {{ __('Scan Biometric') }}
                            </button>
                        </div>
                        <textarea name="biometric_template" id="biometric_template" rows="4"
                            class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring-indigo-500 @error('biometric_template') border-red-500 @enderror"
                            placeholder="Biometric template data (optional)">{{ old('biometric_template', $student->biometric_template) }}</textarea>
                        <p id="biometric-status" class="mt-2 text-xs text-gray-500"></p>
                        @error('biometric_template')
                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <div class="flex justify-end gap-4 mt-6">
                        <a href="{{ route('students.index') }}"
                            class="inline-flex items-center px-6 py-3 bg-gray-500 text-white font-semibold rounded-lg hover:bg-gray-600 transition">
                            {{ __('Cancel') }}
                        </a>
                        <button type="submit"
                            class="inline-flex items-center px-6 py-3 bg-blue-600 text-white font-semibold rounded-lg hover:bg-blue-700 transition">
                            {{ __('Update Student') }}
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    @include('components.biometric-scanner')

</x-app-layout>
