<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreStudentRequest;
use App\Http\Requests\UpdateStudentRequest;
use App\Models\School;
use App\Models\Student;
use Illuminate\Http\Request;

class StudentController extends Controller
{
    public function index(Request $request)
    {
        $query = Student::with('school');

        if ($request->has('school_id') && $request->school_id) {
            $query->where('school_id', $request->school_id);
        }

        $students = $query->paginate(15);

        if ($request->wantsJson()) {
            return response()->json($students);
        }

        $schools = School::all();
        return view('students.index', compact('students', 'schools'));
    }

    public function create(Request $request)
    {
        $schools = School::all();
        $school_id = $request->get('school_id');

        return view('students.create', compact('schools', 'school_id'));
    }

    public function store(StoreStudentRequest $request)
    {
        $student = Student::create($request->validated());

        if ($request->wantsJson()) {
            return response()->json($student, 201);
        }

        return redirect()->route('students.show', $student)
            ->with('success', 'Student created successfully.');
    }

    public function show(Student $student, Request $request)
    {
        $student->load('school');

        if ($request->wantsJson()) {
            return response()->json($student);
        }

        return view('students.show', compact('student'));
    }

    public function edit(Student $student)
    {
        $schools = School::all();

        return view('students.edit', compact('student', 'schools'));
    }

    public function update(UpdateStudentRequest $request, Student $student)
    {
        $student->update($request->validated());

        if ($request->wantsJson()) {
            return response()->json($student);
        }

        return redirect()->route('students.show', $student)
            ->with('success', 'Student updated successfully.');
    }

    public function destroy(Student $student, Request $request)
    {
        $student->delete();

        if ($request->wantsJson()) {
            return response()->json(null, 204);
        }

        return redirect()->route('students.index')
            ->with('success', 'Student deleted successfully.');
    }
}
